clear
set more off
capture log close
version 14

global j "D:\Home\aejack\Research\NewTechnologies\TillReceiptScanning\junk2"



* Devices used for Spending Study
************************************
* keep app launches where action was not completed

use $j/cr-7, clear

svyset i_psu, strata(i_strata)

* drop those found ineligible for the spending study
drop if eligible==0
tab eligible

* drop IP9 non-respondents
tab ip9
tab ip9, nolab
keep if ip9==1

* pick first observation per respondent
bysort pidp (starttime): gen tag = _n==1
tab tag



* Proportion of respondents who used smartphone, tablet or both
*****************************************************************

bysort pidp: egen sum = sum(devicetype)
bysort pidp: gen deviceall_dv = sum/_N
tab deviceall_dv
recode deviceall_dv (1.1/1.9=3) 
lab def deviceall_dv 0 "non-participant" 1 "smartphone only" 2 "tablet only" 3 "both" , modify
lab val deviceall_dv deviceall_dv
lab var deviceall_dv "devices used"

tab deviceall_dv if tag

* in text:
tab deviceall_dv if deviceall~=0 & tag==1



* Device used by IP9 hypothetical willingness
***********************************************
* among respondents who have both devices

gen preference = 1 if i_scwill5sp==i_scwill5tb==1  & i_scwill5sp<4 	&  i_scwill5sp>0 &  i_scwill5sp<. & i_scwill5tb>0 &  i_scwill5tb<.
replace preference = 2 if i_scwill5sp < i_scwill5tb     	&  i_scwill5sp>0 &  i_scwill5sp<. & i_scwill5tb>0 &  i_scwill5tb<.
replace preference = 3 if i_scwill5sp > i_scwill5tb     	&  i_scwill5sp>0 &  i_scwill5sp<. & i_scwill5tb>0 &  i_scwill5tb<.
replace preference = 4 if i_scwill5sp==4 & i_scwill5tb==4   &  i_scwill5sp>0 &  i_scwill5sp<. & i_scwill5tb>0 &  i_scwill5tb<.

lab var preference "hypothetical willingness to use camera"
lab def preference 1 "equally willing on both" 2 "more willing on smartphone" 3 "more willing on tablet" 4 "not willing on either"
lab val preference preference

tab i_scwill5* if tag & i_scwill5sp>0 & i_scwill5tb>0 



tab preference if tag

tab preference deviceall_dv if tag, row

* Table 2:
tab preference deviceall_dv if tag & deviceall_dv>0, row  


exit





